/**
 * 
 */
package jsys.beans;

import java.sql.Connection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;


/**
 * @author Densoism
 *
 */
public class SalesOrderStateController {
    private Connection con;
    private CustomerManager cMgr;
    private ItemManager iMgr;
    private SalesOrderManager sMgr;
    
    private ArrayList sdList;
    
    /**
     * <B>̂ȂRXgN^:</B>f[^x[X̃RlNV擾
     *
     */
    public SalesOrderStateController(){
        
        //f[^x[X̃RlNV擾B
        DBConnection dbc = DBConnection.getInstance();
        con = dbc.getConnection();
        
        sMgr = new SalesOrderManager();
        cMgr = new CustomerManager();
        iMgr = new ItemManager();
    }
    
    /**
     * <B>enterSalesOrderNo:</B>󒍂󒍏ԋ敪Ō
     * @param salesOrderNo
     * @return SalesOrder
     */
    public ArrayList enterSalesOrderSent(String state){
        
        ArrayList list = new ArrayList();
        list = new ArrayList();
        try {
            list = sMgr.findSalesOrderSent(cMgr,iMgr,state,con);
        } catch (Exception e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
        }
        
        String todayDate = DateFormat.getDateInstance().format(new java.util.Date());
        sdList = new ArrayList();
        Iterator it = list.iterator();
        while(it.hasNext()){
            SalesOrder sd = (SalesOrder)it.next();
            if(sd.getDeliveryDate().equals(todayDate)){
                sdList.add(sd);
            }
        }

        return sdList;
    }
    
    /**
     * <B>endConnection:</B>f[^x[X̃RlNVؒfB
     */
    public void endConnection(){
        
        DBConnection dbc = DBConnection.getInstance();
        dbc.close(con);
    }
    
    /**
     * <B>setter:</B>Ӑ}l[W[ݒ肷B
     *      @param  cMgr    Ӑ}l[W[
     */
    public void setCMgr(CustomerManager cMgr){
        this.cMgr = cMgr;
    }
    
    /**
     * <B>setter:</B>i}l[W[ݒ肷B
     *      @param  iMgr    i}l[W[
     */
    public void setIMgr(ItemManager iMgr){
        this.iMgr = iMgr;
    }
    
    /**
     * <B>setter:</B>󒍃}l[W[ݒ肷B
     *      @param  sMgr    󒍃}l[W[
     */
    public void setSMgr(SalesOrderManager sMgr){
        this.sMgr = sMgr;
    }
    
    
    /**
     * <B>getter:</B>Ӑ}l[W[ԂB
     *      @return Ӑ}l[W[
     */
    public CustomerManager getCMgr(){
        return cMgr;
    }
    
    /**
     * <B>getter:</B>i}l[W[ԂB
     *      @return i}l[W[
     */
    public ItemManager getIMgr(){
        return iMgr;
    }
    
    /**
     * <B>getter:</B>󒍃}l[W[ԂB
     *      @return 󒍃}l[W[
     */
    public SalesOrderManager getSMgr(){
        return sMgr;
    }
}
