package jsys.beans;

import java.sql.*;
import java.util.*;

public class SalesOrderRegistController {
	private Connection con;
	private CustomerManager cMgr;
	private ItemManager iMgr;
	private SalesOrderManager sMgr;
	
	//private Customer customer;
	private SalesOrder sObj;
	private Item iObj;
	//private SalesOrderDetail dObj;
	
	/**
	 * <B>̂ȂRXgN^:</B>f[^x[X̃RlNV擾
	 *
	 */
	public SalesOrderRegistController(){
		
		//f[^x[X̃RlNV擾B
		DBConnection dbc = DBConnection.getInstance();
		con = dbc.getConnection();
		//this.con = con;
		
		sMgr = new SalesOrderManager();
		cMgr = new CustomerManager();
		iMgr = new ItemManager();
	}
	
	/**
	 * <B>enterCustomerCode:</B>Ӑ𓾈ӐR[hŌ
	 * @param CustomerCode
	 * @return Customer
	 */
	public SalesOrder enterCustomerCode(String customerCode) throws NotFoundException{
		
		sObj = null;
		if (customerCode != null && !customerCode.equals("")) {
			try {
				// 󒍂쐬
				sObj = sMgr.createSalesOrder(cMgr,iMgr, con, customerCode);
			} catch (Exception e) {
				throw new NotFoundException(e.getMessage());
			}
		}
		return sObj;
	}
	
	/**
	 * <B>addDetail:</B>󒍖ׂǉ
	 */
	public SalesOrder addDetail(String itemCode, String quantityS) throws SalesOrderRegistException
	{
		if(sObj == null){
			throw new SalesOrderRegistException("ӐĂB");
		}
		
		boolean flag = true;
		int quantity = 0;
		try{
			quantity = Integer.parseInt(quantityS);
		}
		catch(NumberFormatException e){
			flag = false;
		}
		if(itemCode == null || itemCode.equals("")){
			flag = false;
		}
		if(quantity <= 0){
			flag = false;
		}
		if(flag == true){
			try{
				// i擾
				Item iObj = iMgr.findByItemCode(itemCode, con);
				
				// i̍݌ɐXV
				iMgr.updateItem(iObj, quantity, con,1);
				
				// i擾A󒍖ׂǉ
				sObj = sMgr.addDetail(iObj, quantity);
			}
			catch(Exception e){
				e.printStackTrace();
			}
		}
		
		return sObj;
	}
	
	/**
	 * <B>addDetail:</B>󒍖ׂύX
	 */
	public SalesOrder changeDetail(String itemCode, String quantityS) throws SalesOrderRegistException
	{
		if(sObj == null){
			throw new SalesOrderRegistException("ӐĂB");
		}
		
		boolean flag = true;
		int quantity = 0;
		try{
			quantity = Integer.parseInt(quantityS);
		}
		catch(NumberFormatException e){
			flag = false;
		}
		if(itemCode == null || itemCode.equals("")){
			flag = false;
		}
		if(quantity <= 0){
			flag = false;
		}
		if(flag == true){
			try{
				Item iObj = null;
				SalesOrderDetail detail = null;
				
				// "itemCode"ɊY󒍖ׂT
				ArrayList sdList = sObj.getSdList();
				Iterator it = sdList.iterator();
				while(it.hasNext()){
					SalesOrderDetail sd = (SalesOrderDetail)it.next();
					//System.out.println(sd.getItem().getItemCode()+"=="+itemCode+"?");
					if(sd.getItem().getItemCode().equals(itemCode)){
System.out.println("YES!!");
						detail = sd;
						break;
					}
				}
				if(detail != null){	 //
					//iZbg
					iObj = iMgr.findByItemCode(itemCode,con);
					
					//i̍݌ɐXV
					int oldQuantity = detail.getQuantity();
					iMgr.updateItem(iObj,oldQuantity,con,2); //DBstockɖ߂
					iMgr.updateItem(iObj,quantity,con,1);
					
					// i擾A󒍖ׂύX
					sObj = sMgr.chengeDetail(detail, quantity);
				}else{
					throw new SalesOrderRegistException("̏i͂܂IĂ܂B");
				}
				
			}
			catch(Exception e){
				e.printStackTrace();
			}
		}
		
		return sObj;
	}
	
	/**
	 * <B>addDetail:</B>󒍖ׂ폜
	 */
	public SalesOrder deleteDetail(String itemCode) throws SalesOrderRegistException
	{
		if(sObj == null){
			throw new SalesOrderRegistException("ӐĂB");
		}
		
		if(!(itemCode == null || itemCode.equals(""))){
			try{
				SalesOrderDetail detail = null;
				// "itemCode"ɊY󒍖ׂT
				ArrayList sdList = sObj.getSdList();
				Iterator it = sdList.iterator();
				while(it.hasNext()){
					SalesOrderDetail sd = (SalesOrderDetail)it.next();
					System.out.println(sd.getItem().getItemCode()+"=="+itemCode+"?");
					if(sd.getItem().getItemCode().equals(itemCode)){
						System.out.println("YES!!");
						detail = sd;
						break;
					}
				}
				
				if(detail != null){	 //
					//iZbg
					iObj = iMgr.findByItemCode(itemCode,con);
					
					//i̍݌ɐXV
					int oldQuantity = detail.getQuantity();
					iMgr.updateItem(iObj,oldQuantity,con,2); //DBstockɖ߂
					
					// 󒍖ׂ폜
					sObj = sMgr.deleteDetail(itemCode);
				}else{
					throw new SalesOrderRegistException("̏i͂܂IĂ܂B");
				}
			}
			catch(Exception e){
				e.printStackTrace();
			}
		}else{
			throw new SalesOrderRegistException("iԍ͂ĂB");
		}
		
		return sObj;
	}
	
	/**
	 * <B>endResist:</B>󒍂͂
	 */
	public SalesOrder endResist() throws SalesOrderRegistException{
//		 󒍂擾
		if(sObj == null){
			throw new SalesOrderRegistException("ӐĂB");
		}
		else{
			ArrayList details = sObj.getSdList();
			if(details.size() == 0){
				throw new SalesOrderRegistException("׏񂪓͂Ă܂B");
			}
		}
		
		try{
			// 󒍂ǉ
			sMgr.entryList(con);
			
			// f[^x[XR~bgAf[^x[XN[Y
			con.commit();
			endConnection();
		}
		catch(Exception e){
			try{
				con.rollback();
				endConnection();
			}
			catch(SQLException ex){
			}
			throw new SalesOrderRegistException(e.getMessage());
		}
		
		return sObj;
	}
	
	/**
	 * <B>endConnection:</B>f[^x[X̃RlNVؒfB
	 */
	public void endConnection(){
		
		DBConnection dbc = DBConnection.getInstance();
		dbc.close(con);
	}
	
	/**
	 * <B>setter:</B>Ӑ}l[W[ݒ肷B
	 * 		@param	cMgr	Ӑ}l[W[
	 */
	public void setCMgr(CustomerManager cMgr){
		this.cMgr = cMgr;
	}
	
	/**
	 * <B>setter:</B>i}l[W[ݒ肷B
	 * 		@param	iMgr	i}l[W[
	 */
	public void setIMgr(ItemManager iMgr){
		this.iMgr = iMgr;
	}
	
	/**
	 * <B>setter:</B>󒍃}l[W[ݒ肷B
	 * 		@param	sMgr	󒍃}l[W[
	 */
	public void setSMgr(SalesOrderManager sMgr){
		this.sMgr = sMgr;
	}
	
	/**
	 * <B>setter:</B>󒍂ݒ肷B
	 * 		@param	sMgr	
	 */
	public void setSObj(SalesOrder sObj){
		this.sObj = sObj;
	}
	
	/**
	 * <B>setter:</B>iݒ肷B
	 * 		@param	sMgr	
	 */
	public void setIObj(Item iObj){
		this.iObj = iObj;
	}
	
	
	/**
	 * <B>getter:</B>Ӑ}l[W[ԂB
	 * 		@return	Ӑ}l[W[
	 */
	public CustomerManager getCMgr(){
		return cMgr;
	}
	
	/**
	 * <B>getter:</B>i}l[W[ԂB
	 * 		@return	i}l[W[
	 */
	public ItemManager getIMgr(){
		return iMgr;
	}
	
	/**
	 * <B>getter:</B>󒍃}l[W[ԂB
	 * 		@return	󒍃}l[W[
	 */
	public SalesOrderManager getSMgr(){
		return sMgr;
	}
	
	/**
	 * <B>getter:</B>󒍂ԂB
	 * 		@return	
	 */
	public SalesOrder getSObj(){
		return sObj;
	}
	
	public Item getIObj(){
		return iObj;
	}
	
}
