package jsys.beans;

/**
 * ##󒍃VXe@SalesOrderManeger##
 * pre
 * t@C : SalesOrderManager.java
 * NXa : 󒍃}lW[
 * @version 1.0
 *
 * 쐬       : 2006/05/29 @author Ό
 * XV       : 2006/05/29 
 * 
 * !--
 * Copyright (C) DENSO ISM. Inc.
 * 1-1 Syouwa. Kariya City. Aichi Pref. JAPAN
 * All rights reserved.
 *
 * ̃\tgEFÁAЃf\[ACZɏ@łD
 * ̋@RkĂ͂Ȃ炸AACZ̈Ӑ}F̌ɂĂgpׂD
 * --
 * /pre
 */
import java.sql.*;
import java.text.*;
import java.util.*;

public class SalesOrderManager {
	private SalesOrder sObj; // 

	private ArrayList salesOrderList;// \`Ŏ擾󒍃Xg

	/**
	 * <B>̂ȂRXgN^:</B>Ȃ
	 */
	public SalesOrderManager() {
		salesOrderList = new ArrayList();
	}

	/**
	 * <B>findSalesOrder:</B>󒍂󒍔ԍŌ
	 * 
	 * @param cMgr
	 *            Ӑ}l[W[
	 * @param iMgr
	 *            ItemManager
	 * @param salesOrderNo
	 *            󒍔ԍ
	 * @param con
	 *            Connection
	 * @return SalesOrder 
	 */
	public SalesOrder findBySalesOrderNo(CustomerManager cMgr,
			ItemManager iMgr, String salesOrderNo, Connection con)
			throws Exception {
		sObj = null;
		try {
			// f[^x[XAʂƂɎ󒍂𐶐
			Statement stmt = con.createStatement();
			String sql = "select * from  where 󒍔ԍ = '" + salesOrderNo
					+ "' ";
			ResultSet res = stmt.executeQuery(sql);
			String customerCode = ""; // ӐR[h
			if (res.next()) {
				sObj = new SalesOrder();

				sObj.setSalesOrderNo(res.getString(1));
				sObj.setTotalAmount(Long.parseLong( res.getString(3) ));
				sObj.setTax(Long.parseLong( res.getString(4) ));
				sObj.setDetailedNum(Integer.parseInt(res.getString(5)));
				sObj.setDeliveryDate(res.getString(6));
				sObj.setDealingsDate(res.getString(7));
				sObj.setState(res.getString(8));
                sObj.calcTotalMoney();
				
				customerCode = res.getString(2);
			}
			Customer customer = cMgr.findByCustomerCode(customerCode, con);
			sObj.setCustomer(customer);
			// 󒍂Ǝ󒍖ׂ̊֘A`
			ArrayList details = findDetails(sObj.getSalesOrderNo(), con,iMgr);
			sObj.setSdList(details);
			salesOrderList.add(sObj);

			res.close();
			stmt.close();
System.out.println("SalesOrderManager::findBySalesOrderNo::END");
System.out.println("findBySalesOrderNo:sObj" + sObj.getSalesOrderNo());
SalesOrderDetail ss = (SalesOrderDetail)sObj.getSdList().get(0);
System.out.println("findBySalesOrderNo:SdList.ItemName" + ss.getItem().getItemName());

		} catch (SQLException e) {
			e.printStackTrace();
			throw new Exception();
		}

		return sObj;
	}

	/**
	 * <B>findSalesOrder:</B>󒍂󒍏ԂŌ
	 * 
	 * @param state
	 *            󒍏
	 * @param con
	 *            Connection
	 * @return SalesOrder 
	 */
	public ArrayList findSalesOrderSent(CustomerManager cMgr, ItemManager iMgr,
			String state, Connection con) throws Exception {
//		String salesOrderNo = null;
		sObj = null;
		try {
			// f[^x[XAʂƂɎ󒍂𐶐
			Statement stmt = con.createStatement();
			String sql = "select * from  where 󒍏ԋ敪 = '" + state + "' ";
			salesOrderList = new ArrayList();
			ResultSet res = stmt.executeQuery(sql);
			String customerCode = ""; // ӐR[h

			while (res.next()) {
				sObj = new SalesOrder(res.getString(1), // 󒍔ԍ
						Long.parseLong(res.getString(3)), // 󒍍vz
						Long.parseLong(res.getString(4)), // Ŋz
						Integer.parseInt(res.getString(5)), // 󒍖׌
						res.getString(6), // [
						res.getString(7), // 󒍓
						res.getString(8) // 󒍏ԋ敪
				);
				customerCode = res.getString(2); // ӐR[h
				Customer customer = cMgr.findByCustomerCode(customerCode, con);
				sObj.setCustomer(customer);
				// 󒍂Ǝ󒍖ׂ̊֘A`
				ArrayList details = findDetails(sObj.getSalesOrderNo(), con,iMgr);
				sObj.setSdList(details);
				salesOrderList.add(sObj);
			}

			res.close();
			stmt.close();


		} catch (SQLException e) {
			e.printStackTrace();
			throw new Exception();
		}

		return salesOrderList;
	}

	/**
	 * Ŏw肵󒍔ԍ󒍖׃XgԂB
	 * 
	 * @param order
	 *            󒍔ԍ
	 * @param con
	 *            RlNV
	 * @return 󒍖׃Xg
	 */
	private ArrayList findDetails(String salesOrderNo, Connection con,ItemManager iMgr) {
		String sql = "select * from 󒍖 where 󒍔ԍ = '" + salesOrderNo + "' ";
		ArrayList sdList = new ArrayList(); // 󒍖׃Xg
		try {
		Statement stmt = con.createStatement();
		ResultSet res = stmt.executeQuery(sql);
			// f[^x[XAʂƂɎ󒍖ׂ𐶐
			res = stmt.executeQuery(sql);
			while (res.next()) {
				SalesOrderDetail sdObj = new SalesOrderDetail(Integer
						.parseInt(res.getString(3)), Long.parseLong(res
						.getString(4)));
				String itemCode = res.getString(2); // iR[h
				Item iObj = iMgr.findByItemCode(itemCode, con);
				sdObj.setItem(iObj);
				sdList.add(sdObj);
SalesOrderDetail ss = (SalesOrderDetail)sdList.get(0);
System.out.println("׋z"+ss.getAmount());
System.out.println("i"+ss.getItem().getItemName());
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return sdList;
	}

	/**
	 * <B>deleteSalesOrder:</B>󒍂
	 * 
	 * @param sObj
	 * @param iMgr
	 * @param con
	 */
	public void deleteSalesOrder(SalesOrder sObj, ItemManager iMgr,
			Connection con) throws SalesOrderCancelException {

		try {
			/** 󒍂̎󒍖ׂ݌ɂɖ߂ * */
			ArrayList sdList = new ArrayList();
			Iterator it = sdList.iterator();
			sdList = sObj.getSdList();
			while (it.hasNext()) {
				SalesOrderDetail sdObj = (SalesOrderDetail) it.next(); // 󒍖ׂo
				Item iObj = sdObj.getItem(); // 󒍖ׂ̎󒍏io
				int quantity = sdObj.getQuantity(); // 󒍖ׂ̎󒍐ʂo
				iMgr.updateItem(iObj, quantity, con, 2); // 󒍐ʂ݌ɂ𑝂₷
			}
		} catch (Exception e) {
			throw new SalesOrderCancelException(e.getMessage());
		}

		try {
			con.setAutoCommit(false); // gUNVJn

			/** 󒍖ׂ * */
			// f[^x[X󒍖ׂ폜
			Statement stmt = con.createStatement();
			String sql = "DELETE FROM 󒍖 where 󒍔ԍ = '"
					+ sObj.getSalesOrderNo() + "' ";
			int deleteCount = stmt.executeUpdate(sql);

			// mFpR\[\
			System.out.println("폜󒍖ׂ̍sF" + deleteCount);
			if (deleteCount < 1) {
				con.rollback();
				return;
			}
			/*
			// sObj̎Ă󒍖׃IuWFNg폜
			ArrayList sdList = sObj.getSdList(); // 󒍖׃Xg
			Iterator it = sdList.iterator();
			while (it.hasNext()) {
				it.remove();
			}
			*/
			/** 󒍂 * */
			// f[^x[X󒍂폜
			stmt = con.createStatement();
			sql = "DELETE FROM  where 󒍔ԍ = '" + sObj.getSalesOrderNo()
					+ "' ";
			deleteCount = stmt.executeUpdate(sql);

			// mFpR\[\
			System.out.println("폜󒍂̍s1̂͂F" + deleteCount);
			if (deleteCount < 1) {
				con.rollback();
			} else {
				con.commit();
                con.close();
			}

		} catch (SQLException e) {
			e.printStackTrace();
		}

	}

	/**
	 * =================================================================================
	 * UC101 󒍓͏
	 */
	// UC101󒍍쐬
	public SalesOrder createSalesOrder(CustomerManager cMgr, ItemManager iMgr,
			Connection con, String customerCode) {
		Customer cObj = new Customer();
		// ڋq
		cObj = cMgr.findByCustomerCode(customerCode, con);
		// 󒍂ƓӐ̊֘A`
		sObj = new SalesOrder(cObj);

		// 󒍔ԍݒ肷
		String salesOrderNo = nextSalesOrderNo(con);
		sObj.setSalesOrderNo(salesOrderNo);

		// f[^
		sObj.setTotalAmount(0);
		sObj.setTax(0);
		sObj.setDetailedNum(0);

		// 󒍏ԋ敪"󒍏"ɃZbg
		sObj.setState("1");

		// 󒍓Ɣ[Zbg
		CalcWeekday cal = new CalcWeekday();
		sObj.setDealingsDate(cal.getDealingsDate()); // 󒍓
		sObj.setDeliveryDate(cal.CalcSetDate()); // 󒍓ɌvZ[
		return sObj;
	}

	/**
	 * 󒍔ԍ̔ԂB
	 * 
	 * @param con
	 *            RlNV
	 * @return 󒍔ԍ
	 */
	public String nextSalesOrderNo(Connection con) {

		String salesOrderNo = null;

		try {
			// SQL𔭍s
			Statement stmt = con.createStatement();
			String sql = "Select Max(󒍔ԍ) from  ";
			ResultSet res = stmt.executeQuery(sql);

			// 󒍔ԍ擾
			if (res.next()) {
				salesOrderNo = res.getString(1);
			} else {
				salesOrderNo = "0";
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}

		if (salesOrderNo == null) {
			salesOrderNo = "0";
		}

		// 󒍔ԍJEgAbv
		int no = Integer.parseInt(salesOrderNo) + 1;
		DecimalFormat df = new DecimalFormat("000000");
		salesOrderNo = df.format(no);

		return salesOrderNo;
	}

	/**
	 * =================================================================================
	 * UC101UC103 󒍖׏
	 */

	/**
	 * 󒍖ׂǉB
	 * 
	 * @param item
	 *            i
	 * @param quantity
	 *            
	 */

	public SalesOrder addDetail(Item item, int quantity) {
		SalesOrderDetail detail = null;
		
		// ׂǉ
		detail = new SalesOrderDetail(item, quantity);
		
		sObj.addDetail(detail);

		// 󒍖׌JEgAbv
		sObj.setDetailedNum(sObj.getDetailedNum() + 1);

		// 󒍍vzƏłvZ
		sObj.calcTotalAmount();
		sObj.calcTax();
		sObj.calcTotalMoney();
		
		return sObj;
	}

	// ɖׂ̕ύXƍ폜Lq
	/**
	 * 󒍖ׂύXB
	 * 
	 * @param item
	 *            i
	 * @param quantity
	 *            
	 */
	public SalesOrder chengeDetail(SalesOrderDetail detail, int quantity) {
		
			//󒍐ʂύX
			detail.setQuantity(quantity);
			
			// 󒍍vzƏłvZ
			sObj.setTotalAmount(0);
			sObj.setTax(0);
			sObj.setTotal(0);
			sObj.calcTotalAmount();
			sObj.calcTax();
			sObj.calcTotalMoney();

		return sObj;
	}
	
	/**
	 * 󒍖ׂ폜B
	 */

	public SalesOrder deleteDetail(String itemCode) throws SalesOrderRegistException{
		boolean isFound = false;
		
		// "itemCode"ɊY󒍖ׂT
		ArrayList sdList = sObj.getSdList();
		Iterator it = sdList.iterator();
		while(it.hasNext()){
			SalesOrderDetail sd = (SalesOrderDetail)it.next();
			//System.out.println(sd.getItem().getItemCode()+"=="+itemCode+"?");
			if(sd.getItem().getItemCode().equals(itemCode)){
				//System.out.println("YES!!");
				it.remove();
				isFound = true;
				break;
			}
		}
		
		if(isFound){	 //ׂ
			// 󒍖׌JEg_E
			sObj.setDetailedNum(sObj.getDetailedNum() - 1);

			// 󒍍vzƏłvZ
			sObj.setTotalAmount(0);
			sObj.setTax(0);
			sObj.setTotal(0);
			sObj.calcTotalAmount();
			sObj.calcTax();
			sObj.calcTotalMoney();

		}else{
			throw new SalesOrderRegistException("̏i͂܂IĂ܂B");
		}

		return sObj;
	}

	/**
	 * =================================================================================
	 * UC101 󒍓o^iDBXVj
	 */
	public void entryList(Connection con) {
		try {
			// SQL𔭍s
			Statement stmt = con.createStatement();
			String sql = "Insert Into  Values (" + "'"
					+ sObj.getSalesOrderNo() + "'," + "'"
					+ sObj.getCustomer().getCustomerCode() + "'," + "'"
					+ sObj.getTotalAmount() + "'," + "'" + sObj.getTax() + "',"
					+ "'" + sObj.getDetailedNum() + "'," + "'"
					+ sObj.getDeliveryDate() + "'," + "'"
					+ sObj.getDealingsDate() + "'," + "'" + sObj.getState()
					+ "')";
			stmt.executeUpdate(sql);

			// 󒍖ׂǉ
			Iterator it = sObj.getSdList().iterator();
			while (it.hasNext()) {
				SalesOrderDetail detail = (SalesOrderDetail) it.next();
				insertDetail(detail, con);
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	/**
	 * =================================================================================
	 * UC101 󒍓o^ UC103 󒍕ύX
	 */

	/**
	 * 󒍖ׂǉBiDBXVj
	 * 
	 * @param detail
	 *            󒍖
	 * @param con
	 *            RlNV
	 */
	private void insertDetail(SalesOrderDetail detail, Connection con) {
		try {
			// SQL𔭍s
			Statement stmt = con.createStatement();
			String sql = "Insert Into 󒍖 Values ( " + "'"
					+ sObj.getSalesOrderNo() + "', " + "'"
					+ detail.getItem().getItemCode() + "', "
					+ detail.getQuantity() + ", " + detail.getAmount() + " )";
			stmt.executeUpdate(sql);
			stmt.close();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	// ɖׂ̕ύXƍ폜DBXVLq
    
}
